using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 1)
    {
      Console.WriteLine("Wywoanie programu: Program plik");
      return;
    }
    String plik = args[0];

    FileInfo fi = new FileInfo(plik);

    if(fi.Exists)
    {
      Console.WriteLine("Plik {0} ju istnieje", plik);
      return;
    }

    FileStream fs;
    try
    {
      fs = fi.Create();
    }
    catch(Exception)
    {
      Console.WriteLine("Plik {0} nie moe by utworzony.", plik);
      return;
    }
    /*
      tutaj mona wykona operacje na pliku
    */
    fs.Close();
    Console.WriteLine("Plik {0} zosta utworzony.", plik);
  }
}
